#!/usr/bin/env python 
# -*- coding: utf-8 -*-

'''
License:
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 3 of the License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
The GNU Public License is available at
http://www.gnu.org/copyleft/gpl.html
'''

from gimpfu import *
import shlex
import subprocess
import os, sys
import tempfile


def save_and_open(image, layer, outputFolder, ext):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    
    if ext == 0:
        gimp.pdb.file_jpeg_save(image, layer, outputFolder + "\\" + layer.name + ".jpg", "raw_filename", 0.9, 0, 0, 0, "Creating with GIMP", 0, 0, 0, 0)
        command = "\"C:/CMYKTool Standalone PL/CMYKTool/cmyktool.exe\" \"" + outputFolder + "/" + layer.name + ".jpg" "\""  #<<<-----SET ME<<<----- path to program cmyktool.exe
        args = shlex.split(command)
        child = subprocess.Popen(args, shell=False)
        child.communicate()
    else:   
		gimp.pdb.file_tiff_save(image, layer, outputFolder + "\\" + layer.name + ".tiff", "raw_filename", 0)
		command = "\"C:/CMYKTool Standalone PL/CMYKTool/cmyktool.exe\" \"" + outputFolder + "/" + layer.name + ".tiff" "\""  #<<<-----SET ME<<<----- path to program cmyktool.exe
		args = shlex.split(command)
		child = subprocess.Popen(args, shell=False)
		child.communicate()

    
register(
    "python_fu_z_Gimp_do_CmykTool_Stand",
    "Uruchom CmykTools z bieżącą warstwą",
    "Zapisuje aktywną warstwę jako *tiff lub *jpeg i otwiera ją w CMYKTool.",
    "MareroQ",
    "Open source GPL",
    "2016",
    "<Image>/Colors/Eksport warstwy do CmykTool...",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Katalog zapisu warstwy:", ""),
		(PF_RADIO, "ext", "Typ pliku:", 1, (("jpg", 0),("tiff",1)))
    ],
    [],
    save_and_open)

main()
